//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of external interrupt
//******************************************
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

void main()
{

	WDCDR.byte = 0x4e;	//clear WDT


	P9CR.bit.b0 = 1;		//set P90 output mode

    P7CR.bit.b6=0;			//set P76(INT3) input mode
	P7PU.bit.b6=1;			//set P76 pull high


	__asm("DI");			//mask all interrupt
	POFFCR3.bit.b3=1;		//enable clock suppy to INT3 and active external interrupt detect
	EINTCR3.byte=0x04;		//Set INT3 falling edge detect
	EIRE.bit.b3=1;			//enable INT3 signal to CPU
	__asm("EI");			//unmask all interrupt   
	
	while(1)
	{
		WDCDR.byte = 0x4e;	//clear WDT
	}          
       	
}

